// fichier  inclures
#include <windows.h>		// En-tte de Windows
#include <d3d8.h>			// En-tte de DirectGraphics
#include <d3dx8.h>			// En-tte de DirectGraphics


// constantes
const int WINDOW_WIDTH = 400;	// Largeur de la fentre en pixel
const int WINDOW_HEIGHT = 300;	// Hauteur de la fentre en pixel
const int WINDOW_X = 0;			// Position de la fentre en x sur le bureau
const int WINDOW_Y = 0;			// Position de la fentre en y sur le bureau
const char *WINDOW_TITLE="DirectGraphics 2";		// Le titre de la fentre
const char *WINDOW_CLASS_NAME="DirectGraphics";		// Le nom de la classe de la fentre


// variables globales
HINSTANCE	g_hInst;	// Handle de l'instance de notre programme
HWND		g_hWnd;		// Handle de notre fentre

LPDIRECT3D8				g_lpD3D;	// Pointeur vers l'interface de Direct3D8
LPDIRECT3DDEVICE8		g_lpDevice;	// Pointeur vers l'interface du device (la carte 3D)

HRESULT		g_hr;		// Les fonctions DirectX retournent toujours un HRESULT 
						// s'il est >= 0 la mthode a march, si < 0 ca a chou
						// La macro FAILED( hr) renvoie true si c'est un code d'erreur


// Structure qui contiendra nos vertices
struct VERTEX
{
    float x, y, z, rhw;		// la position du vertex
    DWORD color;			// la couleur du vertex
	float tu, tv;			// coordonnes de la texture
};

// FVF (Flexible Vertex Format) de notre vertex
#define D3DFVF_VERTEX (D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1 )


// On cre 3 vertices qui dcrivent notre triangle
VERTEX g_Vertices[] =
{
    {  50.0f, 250.0f, 0.5f, 1.0f, 0xff0000ff, 0.0f, 1.0f },		// x, y, z, rhw, color, tu, tv
    { 150.0f,  50.0f, 0.5f, 1.0f, 0xffff0000, 0.0f, 0.0f },
    { 350.0f,  50.0f, 0.5f, 1.0f, 0xff00ff00, 1.0f, 0.0f },	
    { 250.0f, 250.0f, 0.5f, 1.0f, 0xffffffff, 1.0f, 1.0f },
};

// Et notre vertex buffer qui contiendra notre triangle sur la carte vido
LPDIRECT3DVERTEXBUFFER8 g_lpVB=0;

// Notre texture
LPDIRECT3DTEXTURE8	g_lpText=0;



/*
*		InitD3D
*	
*	Intialise Direct3D 8
*	retour: true si russit false si echec
**/
bool InitD3D()
{
	// On cre Direct3D

	g_lpD3D = Direct3DCreate8(D3D_SDK_VERSION);
	if ( g_lpD3D==NULL )	// Si on as pas de pointeur c'est que a a pas march
		return false;



	// On cre un device

	D3DDISPLAYMODE d3ddm;	// Contient des infos sur la rsolution

	// On rempli avec des onformation sur la rsolution courrante
	g_hr =  g_lpD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm );
	if( FAILED( g_hr ) )
		return false;

	
	D3DPRESENT_PARAMETERS d3dpp;				// Contient les info pour crer un device
	ZeroMemory( &d3dpp, sizeof(d3dpp) );		// On mets de zero dans la structure
	d3dpp.Windowed   = TRUE;					// On veut faire un mode fentr				
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;	// Pour le changement de buffer
	d3dpp.BackBufferFormat = d3ddm.Format;		// On prend les format qu'on as remplit plus tt
	d3dpp.BackBufferCount = 1;					// On utilise un back buffer

	// On tente de crer le device sur la carte vido par dfaut, de type hardware (pas mul), 
	// avec des vertex trait en software (on utilise pas de TnL)
	g_hr =  g_lpD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
								D3DCREATE_SOFTWARE_VERTEXPROCESSING,
								&d3dpp, &g_lpDevice );
	if( FAILED( g_hr ) || g_lpDevice == 0 )
		return false;


	// On initialise le device

	// FIXME: ne semble pas marcher au quand on lance le prog la premire fois
	//		erreur de driver ou bien il y a plus de buffer que 1
	// On remplit le buffer de bleue
	g_lpDevice->Clear( 0, 0, D3DCLEAR_TARGET, D3DCOLOR_XRGB( 0x00,0x00,0xff), 0.0f, 0L);
	// Puis on l'affiche
	g_lpDevice->Present(0, 0, 0, 0);






	/************ Vertex buffer ****************/
	// On prpare notre vertex buffer qui contiendra notre triangle

	// On cre un vertex buffer qui peut contenir 4 vertices du type qu'on a crer
	if( FAILED( g_lpDevice->CreateVertexBuffer( 4*sizeof(VERTEX),
                                              0 /* Usage */, D3DFVF_VERTEX,
                                              D3DPOOL_DEFAULT, &g_lpVB ) ) )
		return false;

	// On va obtenir un pointeur vers cet espace mmoire pour copier nos vertices dedans
	VOID* pVertices;

	// On vrouille le vertex buffer pour avoir le pointeur
	if( FAILED( g_lpVB->Lock( 0, sizeof(g_Vertices), (BYTE**)&pVertices, 0 ) ) )
		return false;

	// on copie nos donnes dedans
	memcpy( pVertices, g_Vertices, sizeof(g_Vertices) );

	// Pour on dvrouille le vertex buffer
	g_lpVB->Unlock();






	/*********** Texture	*****************/
	// On va charger notre texture
	D3DXCreateTextureFromFileA( g_lpDevice, "text.png", &g_lpText );
	if( !g_lpText )
		return false;


	// On prpare le mode de rendu pour rendre une texture
	// On va multiplier la valeur de la texture par la valeur de la couleur diffuse
	g_lpDevice->SetTextureStageState( 0, D3DTSS_COLOROP,  D3DTOP_MODULATE );
	g_lpDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	g_lpDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

	// On va aussi filtrer la texture pour que ce soit plus joli
	g_lpDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
	g_lpDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );

	// On filtre aussi le mip-map, mais dans cet exemple ca sert pas trop car on reste toujours dans la mme mip-map
	g_lpDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR );



	return true;
}


/*
*		WndProc
*	
*	Call-back de notre fentre 
*	retour: dpend du message
**/
LRESULT CALLBACK WndProc(HWND hWnd, 
						    UINT msg, 
                            WPARAM wParam, 
                            LPARAM lParam)
{
	switch(msg)
	{	
		// Si une touche est appuy
        case WM_KEYDOWN:
            switch (wParam)
            {
				// Si c'est chap on dit  l'application de finir
                case VK_ESCAPE: PostMessage(hWnd,WM_CLOSE,0,0);
					break;
			}
            break;

		// Si on doit se fermer on ferme la fentre
		case WM_CLOSE:
			DestroyWindow(hWnd);
			break;

		// Sucide du program, on va quitter la boucle des messages
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
	}

	// Si Windows veux faire des chose avec le message courant, on le laisse faire
	return DefWindowProc(hWnd, msg, wParam, lParam);
} 

/*
*		Direct3DRelease
*	
*	Ferme Direct3D
**/
void Direct3DRelease()
{
	// On ferme le vertex buffer
	if(g_lpVB)
		g_lpVB->Release();
	// On ferme le device
	if (g_lpDevice)
		g_lpDevice->Release();
	// Puis on ferme Direct3D
	if (g_lpD3D)
		g_lpD3D->Release();
}


/*
*		InitWindow
*	
*	Intialise une fentre pour qu'on puisse l'utiliser
*	retour: true si russit false si echec
**/
bool InitWindow()
{

    // On crer une classe de fentre
    WNDCLASSEX wc;

	// On dfinit notre classe de fentre
	wc.cbSize       = sizeof(WNDCLASSEX); 
	wc.style		= CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc	= WndProc;				// Notre fonction qui s'occupera de la fentre
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0; 
	wc.hInstance	= g_hInst;				// On donne l'instance du programme
	wc.hIcon		= LoadIcon(NULL, IDI_APPLICATION); 
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW); 
	wc.hbrBackground= (HBRUSH)GetStockObject(BLACK_BRUSH); 
	wc.lpszMenuName	= NULL; 
	wc.lpszClassName= WINDOW_CLASS_NAME;	// Le nom de notre classe de fentre
	wc.hIconSm      = LoadIcon(NULL, IDI_APPLICATION);

	// On enregistre notre classe
    if( !RegisterClassEx( &wc ) )
		return false;

    // On crer notre fentre
    g_hWnd = CreateWindowEx( WS_EX_CLIENTEDGE,
		WINDOW_CLASS_NAME,
		WINDOW_TITLE,
		WS_SYSMENU | WS_BORDER | WS_CAPTION | WS_VISIBLE,
		WINDOW_X, WINDOW_Y,
		WINDOW_WIDTH, WINDOW_HEIGHT,
		GetDesktopWindow(),
		NULL,
		wc.hInstance,
		NULL );

	if( !g_hWnd )
		return false;


	return true;
}



/*
*		Render
*	
*	On va rendre notre triangle
*	retour: true si russit
**/
bool Render()
{
	// On remplit le buffer de bleu
	g_lpDevice->Clear( 0, 0, D3DCLEAR_TARGET, D3DCOLOR_XRGB( 0x00,0x00,0xff), 0.0f, 0L);

	// On entre dans le mode de rendu
	g_lpDevice->BeginScene();

	// On choisit notre vertex buffer
	g_lpDevice->SetStreamSource( 0, g_lpVB, sizeof(VERTEX) );

	// On prviens du format de notre vertex buffer
	g_lpDevice->SetVertexShader( D3DFVF_VERTEX );

	// On mets la texture
	g_lpDevice->SetTexture( 0, g_lpText );



	// On rend notre triangle (on en a 1  rendre)
	// enfin =)
	g_lpDevice->DrawPrimitive( D3DPT_TRIANGLEFAN, 0, 2 );

	// On sort du mode de rendu
	g_lpDevice->EndScene();

	// Puis on l'affiche
	g_lpDevice->Present(0, 0, 0, 0);

	// Voil c'est tout :)
	return true;
}


/*
*		WinMain
*	
*	Point d'entr dans notre program
*	retour: ngatif si chec
**/
int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmdLine, int nShowCmd)
{
	g_hInst = hInst;


	if( !InitWindow() )
		return -1;

	if( !InitD3D() )
		return -2;

	// boucle des messages  de windows
	MSG msg;

	while (1)
	{ 
		// Si on as un message on le traite
		if( PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg); 

			if (msg.message == WM_QUIT)
				break;
		}

		// Sinon dans tout les cas on fait la game logique (logique du jeu)
		Render();
	}

	// On quitte, il faut quitter DirectX d'abord
	Direct3DRelease();

	// Puis on peut partir
	return 0;
}